# Loop 循环

封装订单交易过程的 trade procedure 中有一个循环，会遍历订单中的商品项目，如果当前的商品价格 `@price` 
大于 1000，则将其价格乘 0.9 ，如果 `@total_price` 变量中的总价已经超过 20000，则跳出循环。否则进行
下一个商品项目的处理。这个循环应该是（这里不考虑每个项目本身的处理逻辑，仅考虑折扣和商品订单分割）：

## 答案

```mysql
-- ...
trade: LOOP
    if @price > 1000 then
        set @price = @price * 0.9;
    end if;
    -- ... 
    if @total_price > 20000 then
        LEAVE trade;
    else
        ITERATE trade;
    end if;
    -- ...
end LOOP trace;
```

##  选项

### A

```mysql
-- ...
trade: LOOP
    if @price > 1000 then
        set @price = @price * 0.9;
    end if;
    -- ... 
    if @total_price > 20000 then
        LEAVE trade;
    end if;
    -- ...
end LOOP trace;
```

### B

```mysql
-- ...
trade: LOOP
    if @price > 1000 then
        set @price = @price * 0.9;
    end if;
    -- ... 
    if @total_price > 20000 then
        ITERATE trade;
    else
        LEAVE trade;
    end if;
    -- ...
end LOOP trace;
```

### C

```mysql
-- ...
trade: LOOP
    if @price > 1000 then
        set @price = @price * 0.9;
    end if;
    -- ... 
    if @total_price > 20000 then
        LEAVE trade;
    else
        NEXT trade;
    end if;
    -- ...
end LOOP trace;
```

### D

```mysql
-- ...
trade: LOOP
    if @price > 1000 then
        set @price = @price * 0.9;
    end if;
    -- ... 
    if @total_price > 20000 then
        LEAVE trade;
    end if;
    NEXT trade;
    -- ...
end LOOP trace;
```

